//======================================================================
// Map:			Test Map - Pushing water
//
// Author:		Chruker
// Last edit: 	02/06/2004
//
//======================================================================



//======================================================================
// Environment
//======================================================================
textures/pushing_water/sky
{
	qer_editorimage textures/skies/fueldump_clouds.tga
	q3map_lightrgb 0.8 0.9 1.0
	q3map_notjunc
	q3map_skylight 85 3
	q3map_sun 1 .95 .9 300 210 28
	skyparms - 200 -
	surfaceparm nodlight
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	{
		map textures/skies/fueldump_clouds.tga
		rgbGen identity
	}
	{
		map textures/skies/fueldump_clouds.tga
		blendfunc blend
		rgbGen identity
		tcMod scroll 0.0005 0.00
		tcMod scale 2 1
	}
}





//======================================================================
// Terrain shader
//======================================================================
textures/pushing_water/terrain
{
	qer_editorimage textures/chruker/border_crossing/snow_1.tga
	q3map_lightImage textures/chruker/border_crossing/snow_1.tga
	
	q3map_forceMeta
	q3map_nonplanar
	q3map_shadeAngle 179

	q3map_lightmapAxis z

	q3map_tcGen ivector ( 512 0 0 ) ( 0 512 0 )

	q3map_lightmapSampleSize 64
	q3map_globalTexture

	surfaceparm landmine
	surfaceparm snowsteps

	{
		map textures/chruker/border_crossing/snow_1.tga
		rgbGen identity
		alphaGen vertex
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
}





//======================================================================
// Water textures
//======================================================================
textures/pushing_water/water1
{
	// General Shader Keywords (global, need recompile)
	nopicmip						// Ignore user's setting of r_picmip
	cull none						// Make water surface visible from inside the water
	deformVertexes wave 220 sin 0 60 0 0.2

	// Q3Map2 Specific Shader Keywords (global, need recompile?)
	q3map_globalTexture				// Make sure similar textures on adjacent brushes gets rendered as one (at the expense of precision far away from origin)
	q3map_tcGen ivector ( 0 256 0 ) ( 256 0 0 )		// Display texture at these intervals in game units
	q3map_tessSize 256

	// Q3Map2 Specific Surface Parameter Shader Keywords (global, need recompile?)
//	surfaceparm nomarks				// Projectiles will impact but not leave marks
//	surfaceparm nonsolid			// Doesn't block movement of entities in game
	surfaceparm trans				// Doesn't block during VIS computing
	surfaceparm water				// Give surface and content of brush water properties
	
	// Editor Specific Shader Keywords
	qer_editorimage textures/liquids_sd/sea_bright_na.tga	// Texture displayed in editor
	qer_trans 0.75					// Transparency of texture in editor
		
	// One or more shader stages (no need for recompile, use /vid_restart to reload)
	{
		// Stage Specific Shader Keywords
		map textures/liquids_sd/seawall_specular.tga
		blendFunc add										// Blend (Source * 1) + (Framebuffer * 1)
		rgbGen vertex										// Vertex RGB color values from map
		tcGen environment									// Get texture coordinates from environment
		depthWrite											// Force write to depth buffer (needed for transparent surfaces)
	}
	{
		// Stage Specific Shader Keywords
		map textures/liquids_sd/sea_bright_na.tga			// Source image
		blendFunc blend										// Blend (Source * Alpha) + (Framebuffer * (1 - Alpha))
		rgbGen identity										// Vertex RGB color values are assumed white
		alphaGen const 0.7									// Vertex Alpha value is constant
		tcMod scroll 0.05 0.05								// Scroll texture
	}
}

textures/pushing_water/water2
{
	// General Shader Keywords (global, need recompile)
	nopicmip						// Ignore user's setting of r_picmip
	cull none						// Make water surface visible from inside the water
	deformVertexes wave 56 sin 0 10 0 0.2

	// Q3Map2 Specific Shader Keywords (global, need recompile?)
	q3map_globalTexture				// Make sure similar textures on adjacent brushes gets rendered as one (at the expense of precision far away from origin)
	q3map_tcGen ivector ( 0 256 0 ) ( 256 0 0 )		// Display texture at these intervals in game units
	q3map_tessSize 64

	// Q3Map2 Specific Surface Parameter Shader Keywords (global, need recompile?)
//	surfaceparm nomarks				// Projectiles will impact but not leave marks
//	surfaceparm nonsolid			// Doesn't block movement of entities in game
	surfaceparm trans				// Doesn't block during VIS computing
	surfaceparm water				// Give surface and content of brush water properties
	
	// Editor Specific Shader Keywords
	qer_editorimage textures/liquids_sd/sea_bright_na.tga	// Texture displayed in editor
	qer_trans 0.75					// Transparency of texture in editor
		
	// One or more shader stages (no need for recompile, use /vid_restart to reload)
	{
		// Stage Specific Shader Keywords
		map textures/liquids_sd/seawall_specular.tga
		blendFunc add										// Blend (Source * 1) + (Framebuffer * 1)
		rgbGen vertex										// Vertex RGB color values from map
		tcGen environment									// Get texture coordinates from environment
		depthWrite											// Force write to depth buffer (needed for transparent surfaces)
	}
	{
		// Stage Specific Shader Keywords
		map textures/liquids_sd/sea_bright_na.tga			// Source image
		blendFunc blend										// Blend (Source * Alpha) + (Framebuffer * (1 - Alpha))
		rgbGen identity										// Vertex RGB color values are assumed white
		alphaGen const 0.7									// Vertex Alpha value is constant
		tcMod scroll 0.05 0.05								// Scroll texture
	}
}

textures/pushing_water/water3
{
}

textures/pushing_water/water4
{
}

textures/pushing_water/waternodraw
{
	qer_editorimage textures/common/nodraw.tga
	surfaceparm nodraw
//	surfaceparm nonsolid
	surfaceparm trans
	surfaceparm water
}
